import { Link, useLocation } from 'react-router-dom'
import { Stethoscope, Facebook, Instagram, Youtube, Phone, Mail, MapPin, Clock } from 'lucide-react'
import './Layout.css'

function Layout({ children }) {
  const location = useLocation()

  return (
    <div className="app">
      <header className="header">
        <div className="header-content">
          <div className="logo">
            <div className="logo-icon">
              <Stethoscope className="logo-icon-img" size={32} />
            </div>
            <span className="logo-text">ВетКлиника</span>
          </div>
          <nav className="nav">
            <Link 
              to="/" 
              className={`nav-link ${location.pathname === '/' ? 'active' : ''}`}
            >
              Мои визиты
            </Link>
            <Link 
              to="/book" 
              className={`nav-link ${location.pathname === '/book' ? 'active' : ''}`}
            >
              Записаться
            </Link>
          </nav>
        </div>
      </header>
      <main className="main-content">
        {children}
      </main>
      <footer className="footer">
        <div className="footer-wrapper">
          <div className="footer-main">
            <div className="footer-col">
              <div className="footer-brand">
                <div className="footer-logo">
                  <Stethoscope className="footer-logo-icon" size={28} />
                  <span>ВетКлиника</span>
                </div>
                <p>Ваш надежный партнер в заботе о здоровье питомцев. 
                Профессиональная ветеринарная помощь с 2010 года.</p>
                <div className="footer-social">
                  <a href="#" className="social-btn" aria-label="Facebook">
                    <Facebook className="social-icon" size={18} />
                  </a>
                  <a href="#" className="social-btn" aria-label="Instagram">
                    <Instagram className="social-icon" size={18} />
                  </a>
                  <a href="#" className="social-btn" aria-label="Youtube">
                    <Youtube className="social-icon" size={18} />
                  </a>
                </div>
              </div>
            </div>
            <div className="footer-col">
              <h4>Быстрые ссылки</h4>
              <ul>
                <li><Link to="/book">Записаться онлайн</Link></li>
                <li><a href="#">Наши услуги</a></li>
                <li><a href="#">Врачи</a></li>
                <li><a href="#">Цены</a></li>
                <li><a href="#">Акции</a></li>
              </ul>
            </div>
            <div className="footer-col">
              <h4>Услуги</h4>
              <ul>
                <li><a href="#">Терапия</a></li>
                <li><a href="#">Хирургия</a></li>
                <li><a href="#">Вакцинация</a></li>
                <li><a href="#">Стоматология</a></li>
                <li><a href="#">Груминг</a></li>
              </ul>
            </div>
            <div className="footer-col">
              <h4>Контакты</h4>
              <div className="footer-contacts">
                <div className="footer-contact-item">
                  <Phone className="contact-icon" size={16} />
                  <div>
                    <span>+7 (495) 123-45-67</span>
                    <span className="contact-label">Круглосуточно</span>
                  </div>
                </div>
                <div className="footer-contact-item">
                  <Mail className="contact-icon" size={16} />
                  <span>info@vetclinic.ru</span>
                </div>
                <div className="footer-contact-item">
                  <MapPin className="contact-icon" size={16} />
                  <span>Москва, ул. Ветеринарная, 15</span>
                </div>
                <div className="footer-contact-item">
                  <Clock className="contact-icon" size={16} />
                  <span>Пн-Вс: 9:00 - 21:00</span>
                </div>
              </div>
            </div>
          </div>
          <div className="footer-divider"></div>
          <div className="footer-bottom">
            <p>&copy; 2025 ВетКлиника. Все права защищены.</p>
            <div className="footer-links-bottom">
              <a href="#">Политика конфиденциальности</a>
              <a href="#">Пользовательское соглашение</a>
              <a href="#">Карта сайта</a>
            </div>
          </div>
        </div>
      </footer>
    </div>
  )
}

export default Layout

